pragma solidity ^0.4.24;

import "../../Initializable.sol";
import "./ERC721.sol";
import "../../lifecycle/Pausable.sol";


/**
 * @title ERC721 Non-Fungible Pausable token
 * @dev ERC721 modified with pausable transfers.
 **/
contract ERC721Pausable is Initializable, ERC721, Pausable {
  function initialize() public initializer {
    ERC721.initialize();
    Pausable.initialize();
  }

  function approve(
    address to,
    uint256 tokenId
  )
    public
    whenNotPaused
  {
    super.approve(to, tokenId);
  }

  function setApprovalForAll(
    address to,
    bool approved
  )
    public
    whenNotPaused
  {
    super.setApprovalForAll(to, approved);
  }

  function transferFrom(
    address from,
    address to,
    uint256 tokenId
  )
    public
    whenNotPaused
  {
    super.transferFrom(from, to, tokenId);
  }
}
