var fs = require('fs'),
    chalk = require('chalk'),
    sass = require('./');

/**
 * Render
 *
 * @param {Object} options
 * @param {Object} emitter
 * @api public
 */

module.exports = function(options, emitter) {
  var renderOptions = {
    imagePath: options.imagePath,
    includePaths: options.includePath,
    omitSourceMapUrl: options.omitSourceMapUrl,
    indentedSyntax: options.indentedSyntax,
    outFile: options.dest,
    outputStyle: options.outputStyle,
    precision: options.precision,
    sourceComments: options.sourceComments,
    sourceMap: options.sourceMap
  };

  if (options.src) {
    renderOptions.file = options.src;
  } else if (options.data) {
    renderOptions.data = options.data;
  }

  renderOptions.success = function(css, sourceMap) {
    var todo = 1;
    var done = function() {
      if (--todo <= 0) {
        emitter.emit('done');
      }
    };

    if (options.stdout || (!options.dest && !process.stdout.isTTY)) {
      emitter.emit('log', css);
      return done();
    }

    emitter.emit('warn', chalk.green('Rendering Complete, saving .css file...'));

    fs.writeFile(options.dest, css, function(err) {
      if (err) {
        return emitter.emit('error', chalk.red('Error: ' + err));
      }

      emitter.emit('warn', chalk.green('Wrote CSS to ' + options.dest));
      emitter.emit('write', err, options.dest, css);
      done();
    });

    if (options.sourceMap) {
      todo++;

      fs.writeFile(options.sourceMap, sourceMap, function(err) {
        if (err) {
          return emitter.emit('error', chalk.red('Error' + err));
        }

        emitter.emit('warn', chalk.green('Wrote Source Map to ' + options.sourceMap));
        emitter.emit('write-source-map', err, options.sourceMap, sourceMap);
        done();
      });
    }

    emitter.emit('render', css);
  };

  renderOptions.error = function(error) {
    emitter.emit('error', chalk.red(JSON.stringify(error, null, 2)));
  };

  sass.render(renderOptions);
};
